#include "gui.h"
#include "room.h"
#include "snake.h"
#include "apple.h"
#include <iostream>

int main() {
	hardstart:
    // Create the new Gui and start it. This clears the screen
    // and the Gui now controls the screen
    Gui gui;
    int screenHeight = gui.screenHeight();
    int screenWidth = gui.screenWidth();



    // Create the room, the snake and the apple.
    // You will need to change the constructors later to pass more
    // information to the Snake and Apple constructors
    Snake snake(screenWidth/2, screenHeight/2);
    Position pos;
    
    Apple apple(screenWidth, screenHeight, snake);
    
    Room room(screenWidth, screenHeight);
    int score = 0;
    int& rs = score;
    int sleepnumber = 100;
    int& sleepy = sleepnumber;


    // Enter main loop of the game.
    bool continuePlaying = true;
    while (continuePlaying) {
        // handle key presses
        int ch = gui.getKeypress();
        // Do something with the key press
        // if (c == 'q') {
        //     do something if the user wants to quit
        // } else if (c == KEY_UP) {
        //     do something depending on what was pressed,
        //     e.g. you may want to change the direction of the snake
        // } else if (c == KEY_DOWN) {
        //     do something else
        // }
        if (ch == 'q') {
			continuePlaying = false;
		}
		else if (ch == KEY_UP) {
             //do something depending on what was pressed,
            //e.g. you may want to change the direction of the snake
           snake.changeDirection("UP");
            
         }
         else if (ch == KEY_LEFT) {
			 snake.changeDirection("LEFT");
		 }
		 else if (ch == KEY_RIGHT) {
			 snake.changeDirection("RIGHT");
		 }
		 else if (ch == KEY_DOWN) {
			 snake.changeDirection("DOWN");
		 }
		 
		snake.move();
		
		
        

        // Add your code to move the snake around the screen here.
        // snake.move();

        // Clear the screen
        gui.clear();

        // Redraw everything on the screen into an offscreen buffer,
        // including the room, the snake and the apple
        room.draw(gui);
        snake.draw(gui);
        apple.draw(gui);
        
        gui.drawText(to_string(score), 0, 0, COLOR_WHITE, COLOR_BLACK);
        
        if (apple.ate(screenWidth, screenHeight, snake)) {
			rs += 10;
			sleepy -= 5;
		}
		
		
		
		
		
        if (snake.positions_[0].x == 0 || snake.positions_[0].x == screenWidth - 1
			|| snake.positions_[0].y == 0 || snake.positions_[0].y == screenHeight - 1) {
			continuePlaying = false;
		}
		
		for (int i = 1; i < snake.positions_.size(); i++) {
			
			if (snake.positions_[0].isEqual(snake.positions_[i])) {
				continuePlaying = false;
			}
			
		}
       
        // Display the new drawing all at once
        gui.refresh();

        // Detect whether the snake ate the apple, or it hit the wall
        // or it hit its own tail here
        
        
	
        

        // This call makes the program go quiescent for some time, so
        // that it doesn't run so fast. If the value in the call to
        // sleep is decreased, the game will speed up.
        gui.sleep(sleepnumber);
    }
    while (!continuePlaying) {
		
		gui.clear();
		
		gui.drawLine("+", screenWidth/4, screenHeight/4, 
			3 * screenWidth/4, screenHeight/4, COLOR_WHITE, COLOR_BLACK);
		gui.drawLine("+", 3 * screenWidth/4, screenHeight/4, 
			3 * screenWidth/4, 3 * screenHeight/4, COLOR_WHITE, COLOR_BLACK);
		gui.drawLine("+", 3 * screenWidth/4, 3 * screenHeight/4, 
			screenWidth/4, 3 * screenHeight/4, COLOR_WHITE, COLOR_BLACK);
		gui.drawLine("+", screenWidth/4, 3 * screenHeight/4, 
			screenWidth/4, screenHeight/4,  COLOR_WHITE, COLOR_BLACK);
			
		string gameover = "Score: " + to_string(score);
			
		gui.drawText("GAME OVER :^(", screenWidth/2 - 7, 
			screenHeight/4 + screenHeight/8, COLOR_WHITE, COLOR_BLACK);
		gui.drawText(gameover, screenWidth/2 - gameover.length()/2, screenHeight/2, 
			COLOR_WHITE, COLOR_BLACK);
		gui.drawText("<|:^D Try Again: Y", screenWidth/4 + screenWidth/8 - 9, 
			screenHeight/2 + 1, COLOR_WHITE, COLOR_BLACK);
		gui.drawText(":^o Quit: Q", screenWidth/4 + 3 * screenWidth/8 - 5, 
			screenHeight/2 + 1, COLOR_WHITE, COLOR_BLACK);
		 // handle key presses
        int ch = gui.getKeypress();
        
        if (ch == 'q') {
			break;
		}
		if (ch == 'y') {
			continuePlaying = true;
			goto hardstart;
		}
		gui.sleep(100);
	}
}
