#include "snake.h"

Snake::Snake(int x, int y) {
	x_ = x;
	y_ = y;
	positions_.push_back(Position(x_ , y_));
	positions_.push_back(Position(x_ - 1 , y_));
	positions_.push_back(Position(x - 2 , y_));
}


vector<Position> Snake::getPositions() {
     return positions_;
}

void Snake::move() {
	int x = x_;
	int y = y_;
	
	
	for (int i = positions_.size(); i > 0; i--) {
		/*
		positions_[i].x = x;
		x = positions_[i - 1].x;
		positions_[i].y = y;
		y = positions_[i - 1].y;
		*/
		int& rx = positions_[i].x;
		int& ry = positions_[i].y;
		
		rx = positions_[i-1].x;
		ry = positions_[i-1].y;
		
	}
	if (Snake::direction_ == "RIGHT") {
		positions_[0].x += 1;
	}
	else if (Snake::direction_ == "LEFT") {
		positions_[0].x -= 1;
	}
	else if (Snake::direction_ == "UP") {
		positions_[0].y -= 1;
	}
	else if (Snake::direction_ == "DOWN") {
		positions_[0].y += 1;
	}
	
}

void Snake::changeDirection(string direction) {
	
	string& newdir = direction_;
	
	if (direction_ == "RIGHT" && direction == "LEFT") {
		newdir = direction_;
	}
	else if (direction_ == "LEFT" && direction == "RIGHT") {
		newdir = direction_;
	}
	else if (direction_ == "DOWN" && direction == "UP") {
		newdir = direction_;
	}
	else if (direction_ == "UP" && direction == "DOWN") {
		newdir = direction_;
	}
	else {
		newdir = direction;
	}
}


void Snake::draw(Gui& gui) {
	
	//Draw the head hepending on the direction
	if (Snake::direction_ == "RIGHT") {
		gui.drawText(">", positions_[0].x, positions_[0].y, COLOR_WHITE, COLOR_BLACK);
	}
	else if (Snake::direction_ == "LEFT") {
		gui.drawText("<", positions_[0].x, positions_[0].y, COLOR_WHITE, COLOR_BLACK);
	}
	else if (Snake::direction_ == "UP") {
		gui.drawText("^", positions_[0].x, positions_[0].y, COLOR_WHITE, COLOR_BLACK);
	}
	else if (Snake::direction_ == "DOWN") {
		gui.drawText("v", positions_[0].x, positions_[0].y, COLOR_WHITE, COLOR_BLACK);
	}
	
	//Draw the body of the snake, scale independent. Grows with snake. 
	for (int i = 1; i < positions_.size(); i++) {
		gui.drawText("+", positions_[i].x, positions_[i].y, COLOR_WHITE, COLOR_BLACK);
	}
	
	
}

void Snake::grow() {
	Position grew;
	positions_.push_back(grew);
}

